/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor.toolbox;

import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.content.conductor.toolbox.forge.MountedToolboxEquipPacketImpl;
import com.railwayteam.railways.mixin.AccessorToolboxInventory;
import com.railwayteam.railways.mixin.AccessorToolboxTileEntity;
import com.railwayteam.railways.multiloader.C2SPacket;
import com.railwayteam.railways.util.EntityUtils;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandler;
import com.simibubi.create.content.curiosities.toolbox.ToolboxInventory;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class MountedToolboxEquipPacket
implements C2SPacket {
    private Integer toolboxCarrierId = null;
    private final int slot;
    private final int hotbarSlot;

    public MountedToolboxEquipPacket(ConductorEntity toolboxCarrier, int slot, int hotbarSlot) {
        this.toolboxCarrierId = toolboxCarrier.m_142049_();
        this.slot = slot;
        this.hotbarSlot = hotbarSlot;
    }

    public MountedToolboxEquipPacket(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.toolboxCarrierId = buffer.readInt();
        }
        this.slot = buffer.m_130242_();
        this.hotbarSlot = buffer.m_130242_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.toolboxCarrierId != null);
        if (this.toolboxCarrierId != null) {
            buffer.writeInt(this.toolboxCarrierId.intValue());
        }
        buffer.m_130130_(this.slot);
        buffer.m_130130_(this.hotbarSlot);
    }

    @Override
    public void handle(ServerPlayer player) {
        ToolboxInventory inv;
        AccessorToolboxInventory invAccess;
        ItemStack filterStack;
        Level world = player.f_19853_;
        if (this.toolboxCarrierId == null) {
            ToolboxHandler.unequip((Player)player, (int)this.hotbarSlot, (boolean)false);
            ToolboxHandler.syncData((Player)player);
            return;
        }
        Entity entity = world.m_6815_(this.toolboxCarrierId.intValue());
        double maxRange = ToolboxHandler.getMaxRange((Player)player);
        if (player.m_20280_(entity) > maxRange * maxRange) {
            return;
        }
        if (!(entity instanceof ConductorEntity)) {
            return;
        }
        ConductorEntity conductorEntity = (ConductorEntity)entity;
        ToolboxHandler.unequip((Player)player, (int)this.hotbarSlot, (boolean)false);
        if (this.slot < 0 || this.slot >= 8) {
            ToolboxHandler.syncData((Player)player);
            return;
        }
        MountedToolbox toolbox = conductorEntity.getToolbox();
        if (toolbox == null) {
            return;
        }
        ItemStack held = player.m_150109_().m_8020_(this.hotbarSlot);
        if (!held.m_41619_() && !ToolboxInventory.canItemsShareCompartment((ItemStack)held, (ItemStack)(filterStack = (invAccess = (AccessorToolboxInventory)(inv = ((AccessorToolboxTileEntity)((Object)toolbox)).getInventory())).getFilters().get(this.slot)))) {
            inv.inLimitedMode($ -> MountedToolboxEquipPacket.doEquip(player, this.hotbarSlot, held, inv));
        }
        CompoundTag playerData = EntityUtils.getPersistentData((Entity)player);
        CompoundTag compound = playerData.m_128469_("CreateToolboxData");
        String key = String.valueOf(this.hotbarSlot);
        CompoundTag data = new CompoundTag();
        data.m_128405_("Slot", this.slot);
        data.m_128362_("EntityUUID", conductorEntity.m_142081_());
        data.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)new BlockPos(0, 1000, 0)));
        compound.m_128365_(key, (Tag)data);
        playerData.m_128365_("CreateToolboxData", (Tag)compound);
        toolbox.connectPlayer(this.slot, (Player)player, this.hotbarSlot);
        ToolboxHandler.syncData((Player)player);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void doEquip(ServerPlayer player, int hotbarSlot, ItemStack held, ToolboxInventory inv) {
        void var3_3;
        void var2_2;
        void var1_1;
        MountedToolboxEquipPacketImpl.doEquip(player, (int)var1_1, (ItemStack)var2_2, (ToolboxInventory)var3_3);
    }
}

